/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class JTO<T> {
    private static final Map<TypeToken<?>, Map<String, Parser<?>>> PARSERS = new HashMap();
    private static final Gson GSON = new Gson();
    private String type;
    private JsonObject data;
    private transient T target;
    private transient Supplier<T> func = () -> {
        TypeToken tt = TypeToken.of(Wrapper.clazz());
        Map parsers = PARSERS.getOrDefault(tt, Map.of());
        Parser parser = (Parser)parsers.get(this.type);
        if (parser != null) {
            this.target = parser.func.apply(this.data);
            this.func = () -> this.target;
        }
        return this.target;
    };

    public T get() {
        return this.func.get();
    }

    public static <T> void registerParser(String type, Function<JsonObject, T> func) {
        type = type.toLowerCase();
        TypeToken tt = TypeToken.of(Wrapper.clazz());
        Map parsers = PARSERS.computeIfAbsent(tt, key -> new HashMap());
        if (parsers.containsKey(type)) {
            throw new IllegalArgumentException("A parser for the type '" + type + "' is already registered");
        }
        parsers.put(type, new Parser<T>(func));
    }

    public static <Model, T> void registerParser(String type, Function<Model, T> converter, Supplier<Model> defaultModel, Class<Model> clazz) {
        type = type.toLowerCase();
        JTO.registerParser(type, jso -> {
            Object model = jso != null ? GSON.fromJson((JsonElement)jso, clazz) : defaultModel.get();
            return converter.apply(model);
        });
    }

    public static <T> JTO<T> of(Supplier<T> supplier) {
        JTO<T> jto = new JTO<T>();
        jto.func = supplier;
        return jto;
    }

    private static class Wrapper<T> {
        private Wrapper() {
        }

        static <T> Class<?> clazz() {
            Wrapper<T> dummy = new Wrapper<T>();
            return dummy.getClass();
        }
    }

    private static class Parser<T> {
        public final Function<JsonObject, T> func;

        Parser(Function<JsonObject, T> func) {
            this.func = func;
        }
    }
}

